/******************************************************************************/
class DrawText : BaseEvent
{
public:
            DrawText();
   virtual ~DrawText();
   
   virtual void create(Object &obj);
   virtual void AfterCreate(      ); 

   virtual UInt drawPrepare();
   virtual void drawBlend();
    
private:

   virtual void CallTriggeredAction();
   virtual void StopTriggeredAction();

   VarString* m_VarString;
   UID m_VarStringUID;

   Vec2 m_ScreenPos;
   int m_FontSize;
   bool m_DrawText;
};
/******************************************************************************/
DrawText::DrawText() : BaseEvent(), m_ScreenPos(0), m_FontSize(0), m_DrawText(false), m_VarString(null)                  
{
   
}
DrawText::~DrawText()
{
   
}
/******************************************************************************/
void DrawText::create(Object &obj)
{
   // Getting the parameters from the object in the world
   if(Param *p = obj.findParam("Position"))     m_ScreenPos    = p.asVec2();
   if(Param *p = obj.findParam("Size"))         m_FontSize     = p.asFlt(); 
   if(Param *p = obj.findParam("VarStringUID")) m_VarStringUID = p.asID();  
   
   super.create(obj); // Create the BaseEvent params too
}
/******************************************************************************/
void DrawText::AfterCreate()
{
   // Find the correct VarString to work on. This has to be done here, because it's unreliable during create() (not all objects are loaded yet)
   REPA(variablesString)
      if(variablesString[i].id() == m_VarStringUID)
            m_VarString = &variablesString[i]; 
            
   DEBUG_ASSERT(m_VarString, "Object not found in scene");
}
/******************************************************************************/
uint DrawText::drawPrepare()
{
   return m_VarString->GetDraw() ? IndexToFlag(RM_BLEND) : 0;
}

void DrawText::drawBlend()
{
   TextStyle ts;
   ts.color = WHITE;
   ts.size *= m_FontSize;
   
   D.text(ts, m_ScreenPos, m_VarString->GetValue());
}
/******************************************************************************/
// This method is called when the event was triggered, taking the delay into account
void DrawText::CallTriggeredAction()
{
   m_VarString.SetDraw(true); // Request RM_BLEND in drawPrepare()
}

// This method is called when the duration of the event has been reached
void DrawText::StopTriggeredAction()
{
   m_VarString.SetDraw(false); // Stop requesting RM_BLEND in drawPrepare()
}
/******************************************************************************/